/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.cyberflex;

import com.sun.opencard.opt.security.PrivateKeyAlias;
import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.common.SignatureCardService;
import com.sun.opencard.service.cyberflex.CyberFlexCode;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.terminal.ISOCommandAPDU;

public class CyberFlexSignatureCardService
extends SignatureCardService {
    int apdu_status;
    private PrivateKey privKey;

    public CyberFlexSignatureCardService() {
        this.ocf_codes = new CyberFlexCode();
    }

    public void setup() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == this.ocf_codes.AIDBytes()) {
            return;
        }
        ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_CLAByte(), (int)this.ocf_codes.Select_INSByte(), 4, 0, this.ocf_codes.AIDBytes());
        try {
            ResponseAPDU responseAPDU = this.sendAPDU(iSOCommandAPDU);
        }
        catch (OpenCardException openCardException) {
            openCardException.printStackTrace();
        }
        cardChannel.setState(this.ocf_codes.AIDBytes());
    }

    public ResponseAPDU sendAPDU(ISOCommandAPDU iSOCommandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(iSOCommandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    public byte[] sign(byte[] byArray, PrivateKeyAlias privateKeyAlias, String string, byte[] byArray2) throws CardServiceException, InvalidKeyException, CardTerminalException {
        ResponseAPDU responseAPDU;
        System.out.println("enter my signing fucntion ....");
        try {
            byArray = ServiceUtil.paddingZero(byArray, this.ocf_codes.USER_PIN_LENGTH_Byte());
            if (!string.equals("RSA")) {
                throw new CardServiceException(string + " not supported");
            }
            this.setup();
            int n = 128;
            String string2 = "default";
            byArray2 = this.hashPadData(byArray2);
            byte[] byArray3 = ServiceUtil.arrayJoin(byArray, byArray2);
            ServiceUtil.printhex(byArray3);
            ISOCommandAPDU iSOCommandAPDU = new ISOCommandAPDU((int)this.ocf_codes.Select_RSAByte(), 72, 0, 0, byArray3);
            responseAPDU = this.sendAPDU(iSOCommandAPDU);
            ServiceUtil.printhex(responseAPDU.data());
        }
        catch (OpenCardException openCardException) {
            throw new CardServiceException(openCardException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CardServiceException(noSuchAlgorithmException.getMessage());
        }
        return responseAPDU.data();
    }
}

