/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.service.payflex;

import com.sun.opencard.service.common.OCFCardException;
import com.sun.opencard.service.common.ServiceUtil;
import com.sun.opencard.service.common.UserInfo;
import com.sun.opencard.service.common.UserInfoCardService;
import com.sun.opencard.service.payflex.PayFlexConstants;
import opencard.core.OpenCardException;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class PayFlexUserInfoCardService
extends UserInfoCardService {
    int apdu_status;
    private UserInfo userInfo = new UserInfo();
    private String userName;
    private String userPass;
    private String uid;
    private String appType;

    public UserInfo getUserInfo(String string) throws OpenCardException, OCFCardException {
        this.userInfo.setName(this.getUserName(string));
        this.userInfo.setUID(this.getUserUID(string));
        this.userInfo.setAppType(string);
        return this.userInfo;
    }

    protected void initialize(CardServiceScheduler cardServiceScheduler, SmartCard smartCard, boolean bl) throws CardServiceException {
        super.initialize(cardServiceScheduler, smartCard, bl);
    }

    private void setupUserInfo() throws CardServiceException, CardTerminalException {
        this.allocateCardChannel();
        CardChannel cardChannel = this.getCardChannel();
        if (cardChannel.getState() == PayFlexConstants.payflexAccessAID) {
            return;
        }
        cardChannel.setState(PayFlexConstants.payflexAccessAID);
    }

    private ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws OpenCardException {
        ResponseAPDU responseAPDU = this.getCardChannel().sendCommandAPDU(commandAPDU);
        this.apdu_status = responseAPDU.sw();
        OCFCardException.checkStatus(responseAPDU.sw());
        return responseAPDU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseAPDU sendAPDU(byte[] byArray) {
        ResponseAPDU responseAPDU = null;
        try {
            try {
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var5_4 = null;
                this.releaseCardChannel();
                return responseAPDU;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return responseAPDU;
    }

    public void setUserInfo(byte[] byArray, UserInfo userInfo) throws OpenCardException {
        byte[] byArray2 = ServiceUtil.paddingFF(byArray, 8);
        try {
            this.setUserName(byArray2, userInfo.getName(), userInfo.getAppType());
            this.setUserUID(byArray2, userInfo.getUID(), userInfo.getAppType());
            this.setAppType(byArray2, userInfo.getAppType());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteUserInfo(byte[] byArray, String string) throws OpenCardException {
        byte[] byArray2 = ServiceUtil.paddingFF(byArray, 8);
        this.setUserName(byArray2, "        ", string);
        this.setUserUID(byArray2, "        ", string);
        this.setAppType(byArray2, "        ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName(String string) throws OpenCardException {
        String string2;
        byte[] byArray = null;
        try {
            this.setupUserInfo();
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectUserFile()));
            byArray = this.readRecAPDU((byte)1, (byte)8);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray));
            String string3 = new String(responseAPDU.data()).trim();
            System.out.println("User name = " + string3);
            string2 = string3;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUserName(byte[] byArray, String string, String string2) throws OpenCardException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            try {
                this.setupUserInfo();
                byte[] byArray4 = ServiceUtil.paddingFF(byArray, 8);
                byte[] byArray5 = ServiceUtil.paddingZero(string.getBytes(), 8);
                ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectUserFile()));
                byArray2 = this.verifyKeyAPDU((byte)16, byArray4);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
                byArray3 = this.updateRecAPDU((byte)1, byArray5);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
            }
            catch (Exception exception) {
                System.out.println("Exception : Setting User Name");
                exception.printStackTrace();
                Object var10_11 = null;
                this.releaseCardChannel();
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAppType(byte[] byArray, String string) throws OpenCardException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            try {
                this.setupUserInfo();
                byte[] byArray4 = ServiceUtil.paddingZero(string.getBytes(), 8);
                byte[] byArray5 = ServiceUtil.paddingFF(byArray, 8);
                ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectUserFile()));
                byArray2 = this.verifyKeyAPDU((byte)16, byArray5);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
                byArray3 = this.updateRecAPDU((byte)3, byArray4);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
            }
            catch (Exception exception) {
                System.out.println("Exception : Setting App Type");
                exception.printStackTrace();
                Object var9_10 = null;
                this.releaseCardChannel();
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUserUID(byte[] byArray, String string, String string2) throws OpenCardException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            try {
                this.setupUserInfo();
                byte[] byArray4 = ServiceUtil.paddingFF(byArray, 8);
                byte[] byArray5 = ServiceUtil.paddingZero(string.getBytes(), 8);
                ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.selectCalcFile()));
                responseAPDU = this.sendAPDU(new CommandAPDU(this.verifyKeyAPDU((byte)0, PayFlexConstants.transportKey)));
                byArray2 = this.verifyKeyAPDU((byte)16, byArray4);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
                byArray3 = this.writeRecAPDU((byte)1, byArray5);
                responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
            }
            catch (Exception exception) {
                System.out.println("Exception : Setting User UID");
                Object var10_11 = null;
                this.releaseCardChannel();
                return;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserPassword(byte[] byArray, String string) throws OpenCardException {
        String string2;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            String string3;
            this.setupUserInfo();
            byte[] byArray4 = ServiceUtil.paddingFF(byArray, 8);
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectPasswordFile()));
            byArray3 = this.verifyKeyAPDU((byte)16, byArray4);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
            byArray2 = this.readRecAPDU((byte)1, (byte)8);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
            string2 = string3 = new String(responseAPDU.data()).trim();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPassword(byte[] byArray, String string, String string2) throws OpenCardException {
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            this.setupUserInfo();
            byte[] byArray4 = ServiceUtil.paddingFF(byArray, 8);
            byte[] byArray5 = ServiceUtil.paddingZero(string.getBytes(), 8);
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectPasswordFile()));
            byArray2 = this.verifyKeyAPDU((byte)16, byArray4);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray2));
            byArray3 = this.updateRecAPDU((byte)1, byArray5);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray3));
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserUID(String string) throws OpenCardException {
        String string2;
        byte[] byArray = null;
        try {
            this.setupUserInfo();
            ResponseAPDU responseAPDU = this.sendAPDU(new CommandAPDU(this.selectRoot()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectDedicatedFile()));
            responseAPDU = this.sendAPDU(new CommandAPDU(this.selectUserFile()));
            byArray = this.readRecAPDU((byte)2, (byte)8);
            System.out.println(" In getUserUID : getUserUID = " + byArray);
            responseAPDU = this.sendAPDU(new CommandAPDU(byArray));
            String string3 = new String(responseAPDU.data()).trim();
            System.out.println("User uid = " + string3);
            string2 = string3;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseCardChannel();
            throw throwable;
        }
        this.releaseCardChannel();
        return string2;
    }

    private byte[] verifyKeyAPDU(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = 32;
        byArray2[2] = 0;
        byArray2[3] = by;
        byArray2[4] = 8;
        int n = 5;
        while (n < 13) {
            byArray2[n] = byArray[n - 5];
            ++n;
        }
        return byArray2;
    }

    private byte[] updateRecAPDU(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = -36;
        byArray2[2] = by;
        byArray2[3] = 4;
        byArray2[4] = (byte)byArray.length;
        int n = 5;
        while (n < 5 + byArray.length) {
            byArray2[n] = byArray[n - 5];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            System.out.println("Update Rec apdu[" + n2 + "] = " + byArray2[n2]);
            ++n2;
        }
        return byArray2;
    }

    private byte[] writeRecAPDU(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 0;
        byArray2[1] = -46;
        byArray2[2] = 0;
        byArray2[3] = 2;
        byArray2[4] = (byte)byArray.length;
        int n = 5;
        while (n < 5 + byArray.length) {
            byArray2[n] = byArray[n - 5];
            ++n;
        }
        int n2 = 0;
        while (n2 < byArray2.length) {
            System.out.println("Write Rec apdu[" + n2 + "] = " + byArray2[n2]);
            ++n2;
        }
        return byArray2;
    }

    private byte[] readRecAPDU(byte by, byte by2) {
        byte[] byArray = new byte[]{0, -78, by, 4, by2};
        return byArray;
    }

    private byte[] selectRoot() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 63, 0};
        return byArray;
    }

    private byte[] selectDedicatedFile() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 95, 0};
        return byArray;
    }

    private byte[] selectUserFile() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 95, 48};
        return byArray;
    }

    private byte[] selectCalcFile() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 0, 1};
        return byArray;
    }

    private byte[] selectPasswordFile() {
        byte[] byArray = new byte[]{0, -92, 0, 0, 2, 95, 64};
        return byArray;
    }

    private byte[] string2bytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        int n = 0;
        while (n < byArray.length) {
            short s = cArray[2 * n] > '@' ? (short)(cArray[2 * n] - 55) : (short)(cArray[2 * n] - 48);
            short s2 = cArray[2 * n + 1] > '@' ? (short)(cArray[2 * n + 1] - 55) : (short)(cArray[2 * n + 1] - 48);
            byArray[n] = (byte)(s * 16 + s2);
            ++n;
        }
        return byArray;
    }

    private byte[] createDedicatedFile() {
        byte[] byArray = new byte[10];
        byArray[0] = 0;
        byArray[1] = -92;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 2;
        byArray[5] = 95;
        byArray[6] = 64;
        return byArray;
    }

    private byte[] createUserFile() {
        byte[] byArray = new byte[10];
        return byArray;
    }

    private byte[] writeBlankRecord() {
        byte[] byArray = new byte[10];
        return byArray;
    }

    private byte[] createPinFile() {
        byte[] byArray = new byte[10];
        return byArray;
    }

    private byte[] writePinFile(byte[] byArray) {
        byte[] byArray2 = new byte[10];
        return byArray2;
    }

    private byte[] createPasswordFile() {
        byte[] byArray = new byte[10];
        return byArray;
    }

    private byte[] writePasswordFile() {
        byte[] byArray = new byte[10];
        return byArray;
    }
}

