/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.util.Tracer;

public final class SlotChannel {
    private Tracer itracer = new Tracer((Object)this, class$opencard$core$terminal$SlotChannel == null ? (class$opencard$core$terminal$SlotChannel = SlotChannel.class$("opencard.core.terminal.SlotChannel")) : class$opencard$core$terminal$SlotChannel);
    private static final String SLOTCHANNEL_CLOSED = "SlotChannel CLOSED";
    private static final String SLOTCHANNEL_OPEN = "SlotChannel OPEN";
    private CardTerminal terminal;
    private int slotID;
    private String slotChannelState = "SlotChannel CLOSED";
    private Object userObject = null;
    static /* synthetic */ Class class$opencard$core$terminal$SlotChannel;

    protected SlotChannel(CardTerminal cardTerminal, int n) {
        this.terminal = cardTerminal;
        this.slotID = n;
        this.slotChannelState = SLOTCHANNEL_OPEN;
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU) throws CardTerminalException {
        return this.terminal.sendAPDU(this, commandAPDU, -1);
    }

    public ResponseAPDU sendAPDU(CommandAPDU commandAPDU, int n) throws CardTerminalException {
        return this.terminal.sendAPDU(this, commandAPDU, n);
    }

    public Slot getSlot() {
        return this.terminal.getSlot(this.slotID);
    }

    public int getSlotNumber() {
        return this.slotID;
    }

    public CardTerminal getCardTerminal() {
        return this.terminal;
    }

    public CardID reset(int n) throws CardTerminalException {
        return this.terminal.reset(this, n);
    }

    public CardID reset() throws CardTerminalException {
        return this.reset(-1);
    }

    public boolean isOpen() {
        return this.slotChannelState == SLOTCHANNEL_OPEN;
    }

    public void close() throws CardTerminalException {
        this.itracer.debug("close", "closing channel");
        this.slotChannelState = SLOTCHANNEL_CLOSED;
        this.terminal.closeSlotChannel(this);
    }

    public CardID getCardID() throws CardTerminalException {
        return this.terminal.getCardID(this.slotID);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n+ state ").append(this.slotChannelState);
        return stringBuffer.toString();
    }

    public void setObject(Object object) {
        this.userObject = object;
    }

    public Object getObject() {
        return this.userObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

